#include <SoftwareSerial.h>
#include <DFPlayer_Mini_Mp3.h>


#define hall 2             //Sensor Hall
#define led1 3             //Led verde
#define led2 4             //Led rojo
#define trig1 A1           //Sensor proximidad 1
#define echo1 A2           //Sensor proximidad 1
#define trig2 A4           //Sensor proximidad 2
#define echo2 A3           //Sensor proximidad 2
#define cw1 10             //Motor1 adelante
#define ccw1 9             //Motor1 atras
#define cw2 6              //Motor2 adelante
#define ccw2 5             //Motor2 atras


long d1,d2,t1,t2;
  
void setup() {

//Configuracion de pines
pinMode(led1,OUTPUT); 
pinMode(led2,OUTPUT);
pinMode(trig1,OUTPUT); 
pinMode(trig2,OUTPUT);

pinMode(cw1,OUTPUT); 
pinMode(ccw1,OUTPUT);
pinMode(cw2,OUTPUT); 
pinMode(ccw2,OUTPUT);
pinMode(echo1,INPUT);
pinMode(echo2,INPUT);
pinMode(hall,INPUT);

//Estado Inicial
digitalWrite(led1,LOW); 
digitalWrite(led2,LOW);
digitalWrite(trig1,LOW); 
digitalWrite(trig2,LOW);
analogWrite(cw1,0); 
analogWrite(ccw1,0);
analogWrite(cw2,0); 
analogWrite(ccw2,0);

//mp3_set_serial (Serial);  //set Serial for DFPlayer-mini mp3 module 
//mp3_set_volume (15);
}

void loop() {
  
 sensor1();
 sensor2();

if (digitalRead(hall) == HIGH ){
  digitalWrite(led1,HIGH);
  digitalWrite(led2,LOW);
  
    if ((d2 > 20)&&(d1 > 20)){
      circulo();
    }
    
  if ((d1> 5)&&(d1 < 20)){
     atras();
     delay(1000);
     derecha();
     delay(1000);
     adelante();
     delay(500);
     circulo();
     adelante();
     delay(1000);
  }
if ((d2> 5)&&(d2 < 20)){
     adelante();
     delay(1000);
     izquierda();
     delay(1000);
     atras();
     delay(500);
     circulo();
     atras();
     delay(1000);
  }

  }
  digitalWrite(led2,HIGH);
  digitalWrite(led1,LOW);
      
}

void sensor1(){
     digitalWrite(trig1,LOW);
     delayMicroseconds(2);
     digitalWrite(trig1,HIGH);
     delayMicroseconds(10);
     digitalWrite(trig1,LOW);
     t1 = pulseIn(echo1, HIGH);
     d1 = (t1/2)/29;
     return;
}

void sensor2 (){
     digitalWrite(trig2,LOW);
     delayMicroseconds(2);
     digitalWrite(trig2,HIGH);
     delayMicroseconds(10);
     digitalWrite(trig2,LOW);
     t2 = pulseIn(echo2, HIGH);
     d2 = (t2/2)/29;   
     return;  
}

void adelante () {
    analogWrite(cw1,80);
    analogWrite(ccw1,0);
    analogWrite(cw2,80);
    analogWrite(ccw2,0);
    delay(500);
  return;
  }

void atras(){
    analogWrite(cw1,0);
    analogWrite(ccw1,80);
    analogWrite(cw2,0);
    analogWrite(ccw2,80);
    delay(500);  
    return;
  }


void circulo (){
    analogWrite(cw1,50);
    analogWrite(ccw1,0);
    analogWrite(cw2,20);
    analogWrite(ccw2,0);
    delay(500);
    return;
  }

void izquierda(){
    analogWrite(cw1,80);
    analogWrite(ccw1,0);
    analogWrite(cw2,0);
    analogWrite(ccw2,0);
    delay(500);  
    return;
  }

void derecha(){
    analogWrite(cw1,0);
    analogWrite(ccw1,0);
    analogWrite(cw2,80);
    analogWrite(ccw2,0);
    delay(500);  
    return;
  }

